package MBootstrap;

use MCoreTools;

sub create_world {
  mudlog "BOOTSTRAP: Creating basic world...";

  MIndex->new('room');

  set MIndex 'proto.room', MObject->new(
    comment => 'Room prototype. All rooms should inherit from this.',
    article => 'a',
    name => 'room',
    idesc => 'You are in an unfinished room.',
    sky_vis => 1,
    cnt_closed => 1,
    cnt_inside_open => 0,
  );
  set MIndex 'proto.powers.ashes', set MIndex 'player_proto.ashes', MObject->new(
    comment => 'Used by destroy.',
    name => 'pile of ashes',
    ldesc => 'A small pile of black ashes. They are very coarse, as if whatever produced them burned rapidly',
    weight => 0.001,
  );

  #set MIndex 'room.core.void', MObject->new(
  #  'prototype' => 'room',
  #  article => 'The',
  #  name => 'Void',
  #  idesc => '<self.vis?Total blackness is all you can see<self.aud?, and :. >><self.aud?<self.vis?c:C>omplete silence reaches your ears. >You can feel nothing at all, not even gravity or your own body.',
  #  location => [0,0,0],
  #);

  set MIndex 'room.start', MObject->new(
    'prototype' => 'room',
    article => 'The',
    name => 'Beginning',
    idesc => '<self.vis?Infinite nothingness. Smooth gray surface below, empty dull-blue sky above. ><self.aud?Silence, complete silence...>',
    location => [0,0,0],
  );

  set MIndex 'proto.species.human', set MIndex 'player_proto.human', MObject->new(
    'prototype' => 'species.humanoid',
    'name' => 'human being',
    ok_for_pc => 1,
    ldesc => 'A very ordinary-looking person.',
  );
  set MIndex 'proto.species.horse', set MIndex 'player_proto.horse', MObject->new(
    'prototype' => 'species.herbivore',
    'name' => 'horse',
    ok_for_pc => 1,
    glance_contents => 1,
    weight => 800,
    interior => 800,
  );
  set MIndex 'proto.species.humanoid', MObject->new(
    'prototype' => 'species.generic',
    name => 'humanoid',
    weight => 180,
    density => 0.9,
    has_body_pos => 1,
    can_speak => 1,
    allow_genders => {female => 1, male => 1},
    cnt_interior => 1000,
    parts => {
      'torso' => {weight => 120},
      'left arm' => {weight => 10, parts => {
        'left hand' => {weight => 1, grasp => 1, parts => {
          'left thumb' => {weight => .2},
          'left index finger' => {weight => .2},
          'left middle finger' => {weight => .2},
          'left ring finger' => {weight => .2},
          'left pinky' => {weight => .18},
        }},
      }},
      'right arm' => {weight => 10, parts => {
        'right hand' => {weight => 1, grasp => 1, parts => {
          'right thumb' => {weight => .2},
          'right index finger' => {weight => .2},
          'right middle finger' => {weight => .2},
          'right ring finger' => {weight => .2},
          'right pinky' => {weight => .18},
        }},
      }},
      'left leg' => {weight => 20, parts => {
        'left foot' => {weight => 2},
      }},
      'right leg' => {weight => 20, parts => {
        'right foot' => {weight => 2},
      }},
    },
  );
  set MIndex 'proto.species.herbivore', MObject->new(
    'prototype' => 'species.generic',
    rideable => 1,
    for_sitting => 1,
    allow_genders => {female => 1, male => 1},
  );
  set MIndex 'proto.species.generic', MObject->new(
    'm_hit' => 100,
    'm_move' => 100,
    'c_hit' => 100,
    'c_move' => 100,
    'name' => '<generic creature>',
    'comment' => 'Use this to inherit attributes of basic "aliveness".',
    'has_metabolism' => 1,
    enter_prep => 'on',
    cnt_type => 'open',
    voluntary_carry => 1,
  );
}

sub startup_checks {
  my ($class) = @_;

  MIndex->get('proto') or MIndex->new('proto');
  MIndex->get('player_proto') or MIndex->new('player_proto');
  if (!MIndex->get('room')) {
    $class->create_world;
  }
}  

1;
